% LaTeX2e class file for Vanderbilt Theses
% Written by Brian Sierawski

\LoadClass[12pt]{book}
\ProvidesPackage{vuthesis}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PAGE LAYOUT
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DIMENSION OF TEXT:
\textheight 9in    % creates 1 inch bottom margin
\textwidth 6in     % creates 1 inch right margin

\usepackage[margin=1in,lmargin=1.5in]{geometry}
%\usepackage[breaklinks,pdftex]{hyperref}

% Disallow page breaks at hyphens (this will give some underfull vbox's,
% so an alternative is to use \brokenpenalty=100 and manually search
% for and fix such page breaks)
\brokenpenalty=10000

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ABSTRACT
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prints the abstract page(s) with the prescribed header in the first
% page and a signature line in the last page. No page number is
% printed. I couldn't figure out a way to stop incrementing the page
% number, so I saved the page number at the start of the environment
% in a new counter and then set the page to that value at the end of
% the environment.
% 350 words maximum for dissertation
% 250 words maximum for thesis
%\newcounter{savedpage}                % new counter to
%\renewenvironment{abstract}{\newpage\pagestyle{empty}
%\setcounter{savedpage}{\value{page}}  % save current page number
%\begin{center}
%\hfill\underline{{\MakeUppercase{\@dept}}}\\[5ex]
%\uppercase\expandafter{\@title}\\[5ex]
%\uppercase\expandafter{\@author}\\[5ex]
%\end{center}
%\centerline{\underline{\ifphd Dissertation \else Thesis \fi under the
%direction of\ \@advisor}}}{\vfill\noindent Approved\rule{4in}{0.01in}
%~Date\hrulefill\newpage

%\setcounter{page}{\value{savedpage}}} % restore old page number

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEDICATION
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prints the dedication page
\def\dedication{
  \chapter*{DEDICATION}
  \null\vfill\begin{center}
  \@dedication
  \end{center}\vfill
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ACKNOWLEDGEMENTS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prints the dedication page
\def\acknowledgementspage{
  \chapter*{ACKNOWLEDGEMENTS}
  \label{ACKNOWLEDGEMENTS}
  \@acknowledgements
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TITLE PAGE DEFINITIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% \author, \title are defined in report; here are the rest of the
% front matter defining macros
%\def\dept#1{\gdef\@dept{\uppercase{#1}}}
\def\dept#1{\gdef\@dept{#1}}
\def\degree#1{\gdef\@degree{\uppercase{#1}}}
\def\mastersthesis{\def\@degree{MASTER OF SCIENCE}\phdfalse\copyrightfalse}
\def\phdthesis{\def\@degree{DOCTOR OF PHILOSOPHY}\phdtrue\copyrighttrue}
\def\advisor#1{\gdef\@advisor{#1}}
\def\submitdate#1{\gdef\@submitdate{#1}}
\def\copyrightyear#1{\gdef\@copyrightyear{#1}} % \author, \title in report
\def\@title{What?}\def\@author{Who?}\def\@dept{Which?}
\def\@degree{What?}
% print the month of graduation, not the current month
\def\@submitdate{\ifcase\the\month\or
  May\or May\or May\or May\or August\or August\or
  August\or December\or December\or December\or December\or December\fi,
  \space \number\the\year}
% Someone says that December theses should have the next year as the
% copyright year
\ifnum\month=12
    \@tempcnta=\year \advance\@tempcnta by 1
    \edef\@copyrightyear{\number\the\@tempcnta}
\else
    \def\@copyrightyear{\number\the\year}
\fi
\def\dedication#1{\gdef\@dedication{#1}}
\def\acknowledgements#1{\gdef\@acknowledgements{#1}}

\newif\ifcopyright \newif\ifblof \newif\ifblot \newif\ifphd
\newif\ifprefacedone \prefacedonefalse

% default flags
\copyrighttrue
\phdtrue
\bloftrue
\blottrue

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TITLE PAGE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% defines the look of the title page
\def\titlep{
\thispagestyle{empty}
\begin{center}
    {\normalsize\uppercase\expandafter{\@title}}\\
    \vfill
    By\\
    \vfill
    \@author\\
    \vfill
    \ifphd{Dissertation}\else{Thesis}\fi\\
    Submitted to the Faculty of the\\
    Graduate School of Vanderbilt University\\
    in partial fulfillment of the requirements\\
    for the degree of\\
    \vfill
    \@degree\\
    in\\
    \@dept\\
    \vfill
    \@submitdate\\
    \vfill
    Nashville, Tennessee
\end{center}

\vfill % put as much space as needed to flush the rest to the
       % bottom of the page

% signature lines (5 for phd, 2 for masters)
% 3.75 + 0.25 (blank) + 2.00 = 6.00 in
{\tabcolsep 0in
\ifphd
\noindent\begin{tabular}{lll}
Approved: & \hspace{0.25in} & Date:\\
%\rule{3.75in}{.01in} & & \rule{2in}{.01in}\\
\rule{3.75in}{.01in} & & \rule{2in}{.01in}\\
\rule{3.75in}{.01in} & & \rule{2in}{.01in}\\
\rule{3.75in}{.01in} & & \rule{2in}{.01in}\\
\rule{3.75in}{.01in} & & \rule{2in}{.01in}\\
\rule{3.75in}{.01in} & & \rule{2in}{.01in}
\end{tabular}
\else
\noindent\begin{tabular}{lll}
%Approved: & & Date:\\
%\rule{3.75in}{.01in} & & \rule{2in}{.01in}\\
%\rule{3.75in}{.01in} & & \rule{2in}{.01in}
    Approved:
    \hskip7.5cm
    Date: \\
    \rule{9.2cm}{.01in} \hskip3mm \rule{5.5cm}{.01in}\\
    \rule{9.2cm}{.01in} \hskip3mm \rule{5.5cm}{.01in}
\end{tabular}
\fi}
\newpage}

\def\copyrightpage{
    \null\vfill
    \begin{center}
    \copyright\ Copyright by \@author \hspace{0.7mm}
        \@copyrightyear\\
    All Rights Reserved\\
    \end{center}
    \vfill\newpage}

% creates title page and copyright page (if desired)
\def\maketitlepage{
   %\hypersetup{
   %  pdfauthor={\@author},
   %  pdftitle={\@title},
   %  pdfcreator={pdftex},
   %  pdfsubject={},
   %  pdfkeywords={},
   %  bookmarksnumbered,
   %  pdfstartview={FitV},
   %  colorlinks=false,
   %}

    \pagenumbering{roman}
    \pagestyle{empty}
    \titlep
    \ifcopyright\copyrightpage\fi %zhang 10/30
    \pagestyle{plain}
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TABLES OF CONTENTS, FIGURES, AND TABLES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TABLEOFCONTENTS
%  In report style, \tableofcontents, \listoffigures, etc. are always
%  set in single-column style.
\def\tableofcontents{
  \newpage
  \centerline{TABLE OF CONTENTS}
  \bigskip
  \bigskip
  \vskip 2ex
  \hfill Page\\% first entry in TOC
  \singlespace
  \@starttoc{toc}
  \doublespace
}

% indentation of chapter, section, subsection headings in TOC
\def\l@chapterx{\@dottedtocline{0}{0em}{0em}}
\def\l@chapter{\@dottedtocline{0}{0em}{3em}}
% Modified these to allow numbered sections (Alex Zijdenbos, 10/19/94)
%\def\l@section{\@dottedtocline{1}{4.2em}{0em}}
%\def\l@subsection{\@dottedtocline{2}{7.0em}{0em}}
\def\l@section{\@dottedtocline{1}{3em}{2.5em}}
\def\l@subsection{\@dottedtocline{2}{5.5em}{3em}}

% LIST OF FIGURES
\def\listoffigures{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
 \fi\chapter*{LIST OF FIGURES\@mkboth
  {LIST OF FIGURES}{LIST OF FIGURES}}
 \bigskip
 \singlespace
 \@starttoc{lof}\if@restonecol\twocolumn\fi
 \addtocontents{lof}{\noindent Figure \hfill Page}
 \addtocontents{lof}{\vskip 2ex}
 \addtocontents{toc}{\bigskip}
%% ALS \addtocontents{toc}{\noindent Chapter\\}
 \singlespace
}

% indentation of figure caption in LOF
\def\l@figure{\@dottedtocline{0}{0em}{3em}}

% LIST OF TABLES
%
\def\listoftables{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
  \fi\chapter*{LIST OF TABLES\@mkboth
   {LIST OF TABLES}{LIST OF TABLES}}
%% als below
  \bigskip
 \singlespace
 \@starttoc{lot}\if@restonecol\twocolumn\fi
 \addtocontents{lot}{\noindent Table \hfill Page} %%
 \addtocontents{lot}{\vskip 2ex}
 \doublespace
}

% indentation of table caption in LOT
\let\l@table\l@figure

\def\b{}  % a dummy definition used below

% Add an extra space between 2 captions in list of figures or tables.
% Also, place a period after the number.
\long\def\@caption#1[#2]#3{\par\addcontentsline{\csname
  ext@#1\endcsname}{#1}{\protect\numberline{\hfill\csname
  the#1\endcsname.\hspace{1em}}{\ignorespaces #2}}
  \addtocontents{\csname ext@#1\endcsname}{\vskip 2ex}

  % enable list of tables/figures when the first table/figure is found
  \ifnum \csname c@#1\endcsname = 1
     \immediate\write\@auxout{\string\globaldefs1} % enable LOT/F in aux file
     \immediate\write\@auxout{\string\b\csname ext@#1\endcsname true}
     \immediate\write\@auxout{\string\globaldefs0}
  \fi
  \begingroup
  \@parboxrestore
  \normalsize
  \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}

% inserts the table of contents, list of figs and list of tables
% before Chapter 1 begins
\def\addpreface
{
   \prefacedonetrue
   \newpage
   \dedicationpage
   \acknowledgementspage
   \tableofcontents
   \newpage
   %% ALS
   \ifblot
   {
      \addvspace{10pt}
      \let\saveaddvspace=\addvspace
      \def\addvspace##1{}
      \listoftables
      \let\addvspace=\saveaddvspace
   }
   \newpage
   \fi
   
   \ifblof
   {
      \addvspace{10pt}
      \let\saveaddvspace=\addvspace
      \def\addvspace##1{}
      \listoffigures
      \let\addvspace=\saveaddvspace
   }
   \addtocontents{toc}{\vskip 2ex}
   \addtocontents{toc}{{\parindent 0pt Chapter}}
   \addtocontents{toc}{\vskip 1ex}
   \newpage
   \fi
   \pagenumbering{arabic}  % uses regular numbers, starting from 1
   \pagestyle{plain}
}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CHAPTERS AND SECTIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% chapter and section numbering convention
\def\thechapter       {\Roman{chapter}}
\def\thesection       {}  % no numbers for sections or subsections
\def\thesubsection    {}
\def\thesubsubsection  {}

% the string to print -- changed to APPENDIX with \appendix
\def\@chapapp{CHAPTER}

% Makes the heading for the \chapter command.
\def\@makechapterhead#1{
  {\raggedright
  \center  \@chapapp{} \thechapter\\[5ex] % Print 'Chapter' and number.
  \uppercase {#1}\par
  \nobreak                         % TeX penalty to prevent page break.
  \vskip 5ex
  } }

% Makes the heading for the \chapter* command.
\def\@makeschapterhead#1{             % Heading for \chapter* command
  { \raggedright
    \center \uppercase {#1}\par % Title
    \nobreak                  % TeX penalty to prevent pagebreak
    \vskip 5ex
  } }

\def\chapter{\secdef\@chapter\@schapter}

% for chapters with chapter numbers
\def\@chapter[#1]#2{
   % if this is the first appendix, execute \addappendix;
   % if this is the first chapter, execute \addpreface.
   \ifnum \c@chapter=0 \ifprefacedone\addappendix\else\addpreface\fi\fi
   \clearpage      % Starts new page.
   \global\@topnum\z@        % Prevents figures from going at top of page.
   \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{chapter}
      \typeout{\@chapapp\space\thechapter.}
      \addtocontents{toc}{\protect\cvspace{2ex}}
      \addcontentsline{toc}{chapter}{\protect\numberline{\hfill
      \thechapter.\hspace{1em}}\uppercase{#1}}
      \addtocontents{toc}{\protect\cvspace{2ex}}
   \else
   \fi
   \chaptermark{#1}
   \@makechapterhead{#2}
   \@afterheading             % Routine called after chapter and
}                                  % section heading.

% for chapters without chapter numbers
\def\@schapter#1{
   \clearpage      % Starts new page.
   \global\@topnum\z@        % Prevents figures from going at top of page.
   \addtocontents{toc}{\protect\cvspace{2ex}}
   \addcontentsline{toc}{chapterx}{\uppercase{#1}}
   \@makeschapterhead{#1}
   \@afterheading}

% Read the following to understand how to change heading styles:
% \@startsection {NAME}{LEVEL}{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}
%            optional * [ALTHEADING]{HEADING}
%    Generic command to start a section.
%    NAME       : e.g., 'subsection'
%    LEVEL      : a number, denoting depth of section -- e.g., chapter=1,
%                 section = 2, etc.  A section number will be printed if
%                 and only if LEVEL < or = the value of the secnumdepth
%                 counter.
%    INDENT     : Indentation of heading from left margin
%    BEFORESKIP : Absolute value = skip to leave above the heading.
%                 If negative, then paragraph indent of text following
%                 heading is suppressed.
%    AFTERSKIP  : if positive, then skip to leave below heading,
%                       else - skip to leave to right of run-in heading.
%    STYLE      : commands to set style
%  If '*' missing, then increments the counter.  If it is present, then
%  there should be no [ALTHEADING] argument.  A sectioning command
%  is normally defined to \@startsection + its first six arguments.

% section heading style
\def\section#1{\@startsection{section}{1}{\z@}{5ex plus 1ex minus 0.2ex}{.1pt}
    {\center }
    [{#1}]{\underline{#1}}}

% subsection heading style
\def\subsection{\vskip 5ex   % places the space when subsection immediately
                 % follows section (BEFORESKIP is ignored)
\@startsection{subsection}{2}{\z@}{5ex plus 1ex minus .2ex}{.1pt}
    \center
}

% subsubsection heading style
\def\subsubsection#1{\vskip 5ex   % places the space when subsubsection immediately
                 % follows section (BEFORESKIP is ignored)
\@startsection{subsubsection}{3}{\z@}{5ex plus 1ex minus .2ex}{.1pt}
    {\flushleft }
    [{#1}]{\underline{#1}}
}

% Default initializations of \...mark commands.
\def\chaptermark#1{}

% The value of the counter secnumdepth gives the depth of the
% highest-level sectioning command that is to produce section numbers.
\setcounter{secnumdepth}{2}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DOUBLE SPACING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This style uses interline spacing that is 1.9 times normal, except
% in the figure and table environments where normal spacing is used.
% That can be changed by doing:
% \renewcommand{\baselinestretch}{1.3} (or whatever you want)
% Unfortunately, that command probably won't take effect unless it comes
% before the \begin{document} or after something like \small \normalsize.

\renewcommand{\baselinestretch}{1.9}
\def\singlespace {\renewcommand{\baselinestretch}{1}\@normalsize}
\def\doublespace{\renewcommand{\baselinestretch}{1.9}\@normalsize}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SINGLE SPACED CAPTIONS, FOOTNOTES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Redefine the macro used for floats (including figures and tables)
% so that single spacing is used.
% (Note \def\figure{\@float{figure}set single spacing} doesn't work
%  because figure has an optional argument)
\def\@xfloat#1[#2]{\ifhmode \@bsphack\@floatpenalty -\@Mii\else
   \@floatpenalty-\@Miii\fi\def\@captype{#1}\ifinner
      \@parmoderr\@floatpenalty\z@
    \else\@next\@currbox\@freelist{\@tempcnta\csname ftype@#1\endcsname
       \multiply\@tempcnta\@xxxii\advance\@tempcnta\sixt@@n
       \@tfor \@tempa :=#2\do
                        {\if\@tempa h\advance\@tempcnta \@ne\fi
                         \if\@tempa t\advance\@tempcnta \tw@\fi
                         \if\@tempa b\advance\@tempcnta 4\relax\fi
                         \if\@tempa p\advance\@tempcnta 8\relax\fi
         }\global\count\@currbox\@tempcnta}\@fltovf\fi
    \global\setbox\@currbox\vbox\bgroup
    \singlespace
    \boxmaxdepth\z@
    \hsize\columnwidth \@parboxrestore}

% Redefine the macro used for footnotes to use single spacing
\long\def\@footnotetext#1{\insert\footins{
    \singlespace
    \footnotesize
    \interlinepenalty\interfootnotelinepenalty
    \splittopskip\footnotesep
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM
    \hsize\columnwidth \@parboxrestore
   \edef\@currentlabel{\csname p@footnote\endcsname\@thefnmark}\@makefntext
    {\rule{\z@}{\footnotesep}\ignorespaces
      #1\strut}}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FOOTNOTES:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\footnotesep 8.4pt    % Height of strut placed at the beginning of every
                      % footnote = height of normal \footnotesize strut,
                      % so no extra space between footnotes.

\skip\footins 18pt plus 4pt minus 2pt  % Space between last line of text and
                                         % top of first footnote.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PARAGRAPHING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\parskip 0pt plus 1pt              % Extra vertical space between paragraphs.
\parindent 1.5em                   % Width of paragraph indentation.
\topsep 10pt plus 4pt minus 6pt    % Extra vertical space, in addition to
                                   % \parskip, added above and below list and
                                   % paragraphing environments.
\partopsep 3pt plus 2pt minus 2pt  % Extra vertical space, in addition to
                                   % \parskip and \topsep, added when user
                                   % leaves blank line before environment.
\itemsep 5pt plus 2.5pt minus 1pt  % Extra vertical space, in addition to
                                   % \parskip, added between list items.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIGURE, TABLE NUMBERING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Use the following 4 lines if you dont want the numbering to be reset
% to 1 at the beginning of each chapter.
\def\cl@chapter{\@elt{section}\@elt{footnote}}
\def\thefigure{\@arabic\c@figure}
\def\thetable{\@arabic\c@table}
\def\theequation{\arabic{equation}}

% Else, use the following 3 lines if you want numbering to include the
% current chapter number as an arabic numeral (as opposed to roman)
%\def\thefigure{\@arabic\c@chapter.\@arabic\c@figure}
%\def\thetable{\@arabic\c@table}
%\def\theequation{\arabic{equation}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% APPENDIX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Print the word "Appendix" in the table of contents to herald the
% arrival of appendix titles. Regular report style does not print
% anything.
\def\addappendix{\par
 \addtocontents{toc}{\vskip 2ex}
 \addtocontents{toc}{{\parindent 0pt Appendix}}
 \addtocontents{toc}{\vskip 1ex}
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% BIBLIOGRAPHY
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\thebibliography#1{\chapter*{References\@mkboth
 {REFERENCES}{REFERENCES}}
 \singlespace    % single space lines
 \let\em\it      % use italics for emphasis (unlike rest of text)
 \list
 {[\arabic{enumi}]}{\settowidth\labelwidth{[#1]}\leftmargin\labelwidth
 \advance\leftmargin\labelsep
 \usecounter{enumi}}
 \def\newblock{\hskip .11em plus .33em minus .07em}
 \sloppy\clubpenalty4000\widowpenalty4000
 \sfcode`\.=1000\relax}
\let\endthebibliography=\endlist

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ODDS AND ENDS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\let\em\bf  % emphasize with bold face
\def\cvspace#1  % vspace only if prev command wasn't one
{\ifdim \lastskip =\z@ \vskip #1\relax\fi}
